#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;

#endregion



#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		
		private PriceRejector[] cachePriceRejector;

		
		public PriceRejector PriceRejector()
		{
			return PriceRejector(Input);
		}


		
		public PriceRejector PriceRejector(ISeries<double> input)
		{
			if (cachePriceRejector != null)
				for (int idx = 0; idx < cachePriceRejector.Length; idx++)
					if ( cachePriceRejector[idx].EqualsInput(input))
						return cachePriceRejector[idx];
			return CacheIndicator<PriceRejector>(new PriceRejector(), input, ref cachePriceRejector);
		}

	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		
		public Indicators.PriceRejector PriceRejector()
		{
			return indicator.PriceRejector(Input);
		}


		
		public Indicators.PriceRejector PriceRejector(ISeries<double> input )
		{
			return indicator.PriceRejector(input);
		}
	
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		
		public Indicators.PriceRejector PriceRejector()
		{
			return indicator.PriceRejector(Input);
		}


		
		public Indicators.PriceRejector PriceRejector(ISeries<double> input )
		{
			return indicator.PriceRejector(input);
		}

	}
}

#endregion
